using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Controls;

public partial class AboutDialog : Window
{
    public AboutDialog()
    {
        InitializeComponent();
    }

    void AboutDialog_MouseRightButtonDown(object sender, MouseButtonEventArgs e)
    {
        // Wywietlenie informacji o zdarzeniu
        this.Title = "Source = " + e.Source.GetType().Name + ", OriginalSource = " +
        e.OriginalSource.GetType().Name + " @ " + e.Timestamp;

        // W tym przykadzie wszystkie rda dziedzicz po Control
        Control source = e.Source as Control;

        // Przeczenie krawdzi kontrolki rdowej
        if (source.BorderThickness != new Thickness(5))
        {
            source.BorderThickness = new Thickness(5);
            source.BorderBrush = Brushes.Black;
        }
        else
            source.BorderThickness = new Thickness(0);
    }
}